/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.EntryOrdering;
import com.admc.jcreole.marker.BodyUpdaterMarker;
import com.admc.jcreole.marker.Entry;
import com.admc.jcreole.marker.FootNoteRefMarker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FootNotesMarker
extends BodyUpdaterMarker {
    public List<FootNoteRefMarker> refMarkers = new ArrayList<FootNoteRefMarker>();

    public void add(FootNoteRefMarker refMarker) {
        this.refMarkers.add(refMarker);
    }

    public void updateReferences() {
        for (FootNoteRefMarker refMarker : this.refMarkers) {
            Entry targetEntry = (Entry)this.origKeyToEntry.get(refMarker.getName());
            if (targetEntry == null) {
                throw new IllegalStateException("Orphaned footNote ref");
            }
            refMarker.setEntryLabel(targetEntry.getLabel());
            refMarker.setTargNum(targetEntry.getEntryId());
        }
    }

    public FootNotesMarker(int id, EntryOrdering inOrdering) {
        super(id, inOrdering == null ? EntryOrdering.REF_ORDER : inOrdering);
        switch (this.ordering) {
            case NAME_BY_JAVA: 
            case NAME_BY_DICTIONARY: {
                throw new CreoleParseException("Ordering not supported for FootNotes: " + (Object)((Object)this.ordering));
            }
        }
    }

    public void add(String name) {
        if (this.origKeyToEntry.containsKey(name)) {
            throw new CreoleParseException("Duplicate footnotes definition for: " + name);
        }
        Entry newEntry = new Entry(1 + this.entries.size());
        this.entries.add(newEntry);
        this.origKeyToEntry.put(name, newEntry);
    }

    public void set(String name, String entryHtml) {
        ((Entry)this.origKeyToEntry.get(name)).setHtml(entryHtml);
    }

    @Override
    public void updateBuffer() {
        for (Entry entry : this.entries) {
            this.outBuffer.append(entry.toHtml("jcfn"));
        }
        super.updateBuffer();
    }

    @Override
    public void sort() {
        switch (this.ordering) {
            case DEF_ORDER: {
                for (Entry entry : this.entries) {
                    entry.setLabel(Integer.toString(entry.getEntryId()));
                }
                break;
            }
            case REF_ORDER: {
                HashSet<String> loadedNames = new HashSet<String>();
                ArrayList origEntries = new ArrayList(this.entries);
                this.entries.clear();
                for (FootNoteRefMarker refMarker : this.refMarkers) {
                    Entry targetEntry = (Entry)this.origKeyToEntry.get(refMarker.getName());
                    if (targetEntry == null) {
                        throw new CreoleParseException("No entry defined for referenced name: " + refMarker.getName());
                    }
                    if (loadedNames.contains(refMarker.getName())) continue;
                    loadedNames.add(refMarker.getName());
                    this.entries.add(targetEntry);
                    origEntries.remove(targetEntry);
                    targetEntry.setLabel(Integer.toString(this.entries.size()));
                }
                for (Entry entry : origEntries) {
                    entry.setLabel("unreferenced");
                }
                this.entries.addAll(origEntries);
            }
        }
    }
}

