/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

public class Entry
implements Comparable<Entry> {
    private String html;
    private String label;
    private int entryId;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        return this.compareTo((Entry)o) == 0;
    }

    @Override
    public int compareTo(Entry other) {
        if (other == null) {
            return 1;
        }
        if (other == this) {
            return 0;
        }
        if (this.label == null && other.label == null) {
            return Integer.valueOf(this.entryId).compareTo(other.entryId);
        }
        if (this.label == null) {
            return -1;
        }
        if (other.label == null) {
            return 1;
        }
        return this.label.compareTo(other.label);
    }

    public int getEntryId() {
        return this.entryId;
    }

    public Entry(int entryId) {
        this.entryId = entryId;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return this.getLabel();
    }

    public String toHtml(String prefix) {
        if (this.label == null) {
            throw new IllegalStateException("Label not set yet for entry");
        }
        if (this.html == null) {
            throw new IllegalStateException("Html not set yet for entry: " + this.label);
        }
        if (prefix != null && this.entryId < 0) {
            throw new IllegalStateException("Prefix set but entryId not set for entry: " + this.label);
        }
        StringBuilder sb = new StringBuilder().append("<dl");
        if (prefix != null) {
            sb.append(" id=\"").append(prefix).append(this.entryId).append('\"');
        }
        return sb.append(">\n  <dt>").append(this.label).append("</td>\n  <dd>").append(this.html).append("</dd>\n</dl>\n").toString();
    }
}

