/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import com.admc.jcreole.Token;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LiSymbol
extends Token {
    private char type;
    private String content;
    private boolean headed;
    private char enumSymbol;
    static Pattern EnumSymbolPattern = Pattern.compile("(?s)([1aAiI]#)(.*)");

    public LiSymbol(Token sourceToken) {
        super(sourceToken.getId(), null, sourceToken.getOffset(), sourceToken.getLine(), sourceToken.getColumn(), sourceToken.getIntParam() < 0 ? -sourceToken.getIntParam() : sourceToken.getIntParam());
        this.headed = sourceToken.getIntParam() < 0;
        String s = sourceToken.getStringVal();
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.length() != 1) {
            throw new IllegalArgumentException("Malformatted type: " + s);
        }
        this.type = s.charAt(0);
        if (this.getIntParam() < 1 || this.getIntParam() > 6) {
            throw new IllegalArgumentException("Illegal list level: " + this.getIntParam());
        }
    }

    public void setContent(String content) {
        Matcher matcher = EnumSymbolPattern.matcher(content);
        if (matcher.matches()) {
            this.enumSymbol = matcher.group(1).charAt(0);
            this.content = matcher.group(2);
        } else {
            this.content = content;
        }
        if (this.content.length() < 1) {
            throw new IllegalArgumentException("Empty list items prohibited");
        }
    }

    public char getEnumSymbol() {
        return this.enumSymbol;
    }

    public char getType() {
        return this.type;
    }

    public int getLevel() {
        return this.getIntParam();
    }

    public String getContent() {
        if (!this.headed) {
            return this.content;
        }
        int pipeOffset = this.content.indexOf(124);
        StringBuilder sb = new StringBuilder();
        Matcher matcher = EnumSymbolPattern.matcher(this.content);
        if (matcher.matches()) {
            sb.append(matcher.group(1));
        }
        if (pipeOffset != 0) {
            sb.append("<span class=\"jcreole_lh\">").append(this.content.substring(matcher.matches() ? 2 : 0, pipeOffset > 0 ? pipeOffset : this.content.length())).append("</span>");
        }
        if (pipeOffset > -1 && pipeOffset != this.content.length() - 1) {
            sb.append("<span class=\"jcreole_ld\">").append(this.content.substring(pipeOffset + 1)).append("</span>");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return Character.toString(this.type) + this.getLevel() + ": <li level=\"" + this.getLevel() + "\">" + this.content + '>';
    }
}

