/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.marker.BufferMarker;

public class LinkMarker
extends BufferMarker {
    private String linkText;
    private String label;

    public LinkMarker(int id, String linkText) {
        super(id);
        if (linkText.length() < 1 || linkText.charAt(0) != '#') {
            throw new IllegalStateException("Local link does not begin with '#': " + linkText);
        }
        this.linkText = linkText;
    }

    public String getLinkText() {
        return this.linkText;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (this.label != null) {
            throw new IllegalStateException("Label has already been set");
        }
        this.label = label;
    }

    public void wrapLabel(String prefix, String suffix) {
        if (this.label == null) {
            throw new IllegalStateException("Can't call wrapLabel before base label has been set");
        }
        this.label = prefix + this.label + suffix;
    }

    @Override
    public void updateBuffer() {
        super.updateBuffer();
        if (this.label != null) {
            this.targetSb.insert(this.offset, this.label);
        }
    }
}

