/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.Token;

class TabSymbol
extends Token {
    private String content;
    private String label;
    private int refId;

    public TabSymbol(Token sourceToken, String wholeString, int refId) {
        super(sourceToken.getId(), null, sourceToken.getOffset(), sourceToken.getLine(), sourceToken.getColumn());
        this.refId = refId;
        int pipeIndex = wholeString.indexOf(124);
        if (pipeIndex < 1) {
            throw new CreoleParseException("No tab label/content/delimiter: " + wholeString, sourceToken);
        }
        if (pipeIndex >= wholeString.length() - 1) {
            throw new CreoleParseException("No tab content: " + wholeString, sourceToken);
        }
        this.label = wholeString.substring(0, pipeIndex);
        this.content = wholeString.substring(pipeIndex + 1);
    }

    public String getLabelLi() {
        return "<li><a href=\"#jcreole_tab" + this.refId + "\">" + this.label + "</a></li>";
    }

    public String getContentBlock() {
        return "<div id=\"jcreole_tab" + this.refId + "\">\n    " + this.content + "\n  </div>";
    }

    @Override
    public String toString() {
        return this.getLabelLi() + '\n' + this.getContentBlock();
    }
}

