/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.marker.BufferMarker;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class TagMarker
extends BufferMarker {
    private boolean writeAttr;
    private List<String> cssClasses = new ArrayList<String>();
    private String tagName;
    private boolean atomic;

    public TagMarker(int id, String tagName, boolean writeAttr, boolean atomic) {
        super(id);
        this.tagName = tagName;
        this.writeAttr = writeAttr;
        this.atomic = atomic;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void addCssClasses(String[] newNames) {
        for (String name : newNames) {
            if (this.cssClasses.contains(name)) continue;
            this.cssClasses.add(name);
        }
    }

    @Override
    public void updateBuffer() {
        super.updateBuffer();
        if (this.cssClasses.size() < 1) {
            return;
        }
        String classesString = StringUtils.join(this.cssClasses, (char)' ');
        this.targetSb.insert(this.offset, this.writeAttr ? " class=\"" + classesString + '\"' : " " + classesString);
    }

    @Override
    public String toString() {
        return this.getIdString() + '/' + this.getClass().getName().replaceFirst(".*\\.", "") + ':' + this.getTagName() + (this.applied ? "" : "@" + this.offset);
    }

    public boolean isAtomic() {
        return this.atomic;
    }
}

