/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.EntryType;
import com.admc.jcreole.SectionHeading;
import com.admc.jcreole.Sections;
import com.admc.jcreole.TagType;
import com.admc.jcreole.marker.BlockMarker;
import com.admc.jcreole.marker.BodyUpdaterMarker;
import com.admc.jcreole.marker.BufferMarker;
import com.admc.jcreole.marker.CloseMarker;
import com.admc.jcreole.marker.DeferredUrlMarker;
import com.admc.jcreole.marker.FootNoteRefMarker;
import com.admc.jcreole.marker.FootNotesMarker;
import com.admc.jcreole.marker.HeadingMarker;
import com.admc.jcreole.marker.IndexMarker;
import com.admc.jcreole.marker.IndexedMarker;
import com.admc.jcreole.marker.InlineMarker;
import com.admc.jcreole.marker.JcxBlockMarker;
import com.admc.jcreole.marker.JcxSpanMarker;
import com.admc.jcreole.marker.LinkMarker;
import com.admc.jcreole.marker.MasterDefListMarker;
import com.admc.jcreole.marker.Styler;
import com.admc.jcreole.marker.TagMarker;
import com.admc.jcreole.marker.TocMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MarkerMap
extends HashMap<Integer, BufferMarker> {
    private static Log log = LogFactory.getLog(MarkerMap.class);
    private Sections sections;
    private Map<String, String> idToTextHMap = new HashMap<String, String>();
    private String enumerationFormats;
    private StringBuilder buffer;
    private MasterDefListMarker masterDefListMarker;
    private FootNotesMarker footNotesMarker;
    private IndexMarker indexMarker;
    private Map<String, String> nameToDefHtml = new HashMap<String, String>();

    public StringBuilder apply(StringBuilder sb, String enumerationFormats) {
        EntryType eType;
        String name;
        int offsetNl;
        if (enumerationFormats == null) {
            throw new NullPointerException("enumerationFormats may not be null");
        }
        this.buffer = sb;
        for (BufferMarker m : this.values()) {
            if (m instanceof MasterDefListMarker) {
                this.masterDefListMarker = (MasterDefListMarker)m;
                continue;
            }
            if (m instanceof FootNotesMarker) {
                this.footNotesMarker = (FootNotesMarker)m;
                continue;
            }
            if (!(m instanceof IndexMarker)) continue;
            this.indexMarker = (IndexMarker)m;
        }
        this.enumerationFormats = enumerationFormats;
        this.setContexts();
        ArrayList<BufferMarker> sortedMarkers = new ArrayList<BufferMarker>(this.values());
        Collections.sort(sortedMarkers);
        if (this.size() < 1) {
            return this.buffer;
        }
        this.forwardPass1(sortedMarkers);
        int offset3 = -1;
        int offset2 = -1;
        while ((offset2 = this.buffer.indexOf("\u0002", offset3 + 1)) > -1) {
            offsetNl = this.buffer.indexOf("\n", offset2 + 2);
            if (offsetNl < 0) {
                throw new CreoleParseException("No name termination for Entry");
            }
            offset3 = this.buffer.indexOf("\u0003", offsetNl + 1);
            if (offset3 < 0) {
                throw new CreoleParseException("No termination for Entry");
            }
            name = this.buffer.substring(offset2 + 2, offsetNl);
            if (name.length() < 1) {
                throw new CreoleParseException("Empty embedded name for Entry");
            }
            switch (this.buffer.charAt(offset2 + 1)) {
                case 'D': {
                    eType = EntryType.MASTERDEF;
                    break;
                }
                case 'F': {
                    eType = EntryType.FOOTNOTE;
                    break;
                }
                default: {
                    throw new CreoleParseException("Unexpected EntryType indicator: " + this.buffer.charAt(offset2 + 1));
                }
            }
            if (this.footNotesMarker != null && eType == EntryType.FOOTNOTE) {
                this.footNotesMarker.add(name);
                continue;
            }
            if (this.masterDefListMarker == null || eType != EntryType.MASTERDEF) continue;
            this.masterDefListMarker.add(name);
        }
        if (this.footNotesMarker != null) {
            this.footNotesMarker.sort();
            this.footNotesMarker.updateReferences();
        }
        if (this.masterDefListMarker != null) {
            this.masterDefListMarker.sort();
            this.masterDefListMarker.updateReferences();
        }
        if (this.indexMarker != null) {
            this.indexMarker.generateEntries();
            this.indexMarker.sort();
        }
        this.forwardPass2(sortedMarkers);
        log.debug(Integer.toString(this.sections.size()) + " Section headings: " + this.sections);
        Collections.reverse(sortedMarkers);
        for (BufferMarker m : sortedMarkers) {
            if (m instanceof BodyUpdaterMarker) continue;
            m.updateBuffer();
        }
        offset2 = 0;
        while ((offset2 = this.buffer.indexOf("\u0002", offset2)) > -1) {
            offsetNl = this.buffer.indexOf("\n", offset2 + 2);
            if (offsetNl < 0) {
                throw new CreoleParseException("No name termination for Entry");
            }
            offset3 = this.buffer.indexOf("\u0003", offsetNl + 1);
            if (offset3 < 0) {
                throw new CreoleParseException("No termination for Entry");
            }
            name = this.buffer.substring(offset2 + 2, offsetNl);
            if (name.length() < 1) {
                throw new CreoleParseException("Empty embedded name for Entry");
            }
            switch (this.buffer.charAt(offset2 + 1)) {
                case 'D': {
                    eType = EntryType.MASTERDEF;
                    break;
                }
                case 'F': {
                    eType = EntryType.FOOTNOTE;
                    break;
                }
                default: {
                    throw new CreoleParseException("Unexpected EntryType indicator: " + this.buffer.charAt(offset2 + 1));
                }
            }
            if (this.footNotesMarker != null && eType == EntryType.FOOTNOTE) {
                this.footNotesMarker.set(name, this.buffer.substring(offsetNl + 1, offset3));
            } else if (this.masterDefListMarker != null && eType == EntryType.MASTERDEF) {
                this.masterDefListMarker.set(name, this.buffer.substring(offsetNl + 1, offset3));
            }
            this.buffer.delete(offset2, offset3 + 1);
        }
        this.setContexts();
        Collections.sort(sortedMarkers);
        Collections.reverse(sortedMarkers);
        for (BufferMarker m : sortedMarkers) {
            if (m == this.indexMarker) {
                this.indexMarker.updateBuffer();
                continue;
            }
            if (m == this.footNotesMarker) {
                this.footNotesMarker.updateBuffer();
                continue;
            }
            if (m != this.masterDefListMarker) continue;
            this.masterDefListMarker.updateBuffer();
        }
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContexts() {
        int offset = 0;
        while ((offset = this.buffer.indexOf("\u001a", offset)) > -1) {
            try {
                if (this.buffer.length() < offset + 4) {
                    throw new CreoleParseException("Marking too close to end of output");
                }
                String idString = this.buffer.substring(offset + 1, offset + 5);
                int id = Integer.parseInt(idString, 16);
                BufferMarker marker = (BufferMarker)this.get(id);
                if (marker == null) {
                    throw new IllegalStateException("Lost marker with id " + id);
                }
                marker.setContext(this.buffer, offset);
            }
            finally {
                offset += 5;
            }
        }
    }

    private void forwardPass1(List<BufferMarker> sortedMarkers) {
        HashMap nameToRefNum = new HashMap();
        for (BufferMarker m : sortedMarkers) {
            if (m instanceof HeadingMarker) {
                HeadingMarker hm = (HeadingMarker)m;
                SectionHeading sectionHeading = hm.getSectionHeading();
                this.idToTextHMap.put(sectionHeading.getXmlId(), sectionHeading.getText());
                continue;
            }
            if (m instanceof TocMarker) {
                ((TocMarker)m).setDefaultLevelInclusions(this.enumerationFormats);
                continue;
            }
            if (m instanceof FootNoteRefMarker) {
                if (this.footNotesMarker == null) continue;
                this.footNotesMarker.add((FootNoteRefMarker)m);
                continue;
            }
            if (m instanceof IndexedMarker) {
                if (this.indexMarker == null) continue;
                this.indexMarker.add((IndexedMarker)m);
                continue;
            }
            if (!(m instanceof DeferredUrlMarker) || this.masterDefListMarker == null) continue;
            this.masterDefListMarker.add((DeferredUrlMarker)m);
        }
    }

    private void forwardPass2(List<BufferMarker> sortedMarkers) {
        this.sections = new Sections();
        ArrayList<TagMarker> stack = new ArrayList<TagMarker>();
        ArrayList<InlineMarker> typedStack = null;
        ArrayList<String> queuedJcxSpanClassNames = new ArrayList<String>();
        ArrayList queuedJcxBlockClassNames = new ArrayList();
        ArrayList queuedBlockClassNames = new ArrayList();
        ArrayList queuedInlineClassNames = new ArrayList();
        ArrayList<String> typedQueue = null;
        ArrayList<JcxSpanMarker> jcxSpanStack = new ArrayList<JcxSpanMarker>();
        ArrayList<JcxBlockMarker> jcxBlockStack = new ArrayList<JcxBlockMarker>();
        ArrayList<BlockMarker> blockStack = new ArrayList<BlockMarker>();
        ArrayList<InlineMarker> inlineStack = new ArrayList<InlineMarker>();
        JcxSpanMarker prevJcxSpan = null;
        JcxBlockMarker prevJcxBlock = null;
        BlockMarker prevBlock = null;
        InlineMarker prevInline = null;
        int headingLevel = 0;
        int[] curSequences = new int[]{-1, -1, -1, -1, -1, -1};
        for (BufferMarker m : sortedMarkers) {
            if (m instanceof TagMarker) {
                TagMarker tagM = (TagMarker)m;
                if (!(tagM instanceof JcxSpanMarker || tagM instanceof JcxBlockMarker || tagM instanceof BlockMarker || tagM instanceof InlineMarker)) {
                    throw new RuntimeException("Unexpected class for TagMarker " + tagM + ": " + tagM.getClass().getName());
                }
                if (tagM.isAtomic()) {
                    if (tagM instanceof JcxSpanMarker) {
                        prevJcxSpan = (JcxSpanMarker)tagM;
                    } else if (tagM instanceof JcxBlockMarker) {
                        prevJcxBlock = (JcxBlockMarker)tagM;
                    } else if (tagM instanceof BlockMarker) {
                        prevBlock = (BlockMarker)tagM;
                    } else if (tagM instanceof InlineMarker) {
                        prevInline = (InlineMarker)tagM;
                    }
                } else {
                    if (tagM instanceof JcxSpanMarker) {
                        jcxSpanStack.add(0, (JcxSpanMarker)tagM);
                    } else if (tagM instanceof JcxBlockMarker) {
                        jcxBlockStack.add(0, (JcxBlockMarker)tagM);
                    } else if (tagM instanceof BlockMarker) {
                        blockStack.add(0, (BlockMarker)tagM);
                    } else if (tagM instanceof InlineMarker) {
                        inlineStack.add(0, (InlineMarker)tagM);
                    }
                    stack.add(0, tagM);
                }
                typedQueue = null;
                if (tagM instanceof JcxSpanMarker) {
                    if (queuedJcxSpanClassNames.size() > 0) {
                        typedQueue = queuedJcxSpanClassNames;
                    }
                } else if (tagM instanceof JcxBlockMarker) {
                    if (queuedJcxBlockClassNames.size() > 0) {
                        typedQueue = queuedBlockClassNames;
                    }
                } else if (tagM instanceof BlockMarker) {
                    if (queuedBlockClassNames.size() > 0) {
                        typedQueue = queuedBlockClassNames;
                    }
                } else if (tagM instanceof InlineMarker && queuedInlineClassNames.size() > 0) {
                    typedQueue = queuedInlineClassNames;
                }
                if (typedQueue != null) {
                    tagM.addCssClasses(typedQueue.toArray(new String[0]));
                    typedQueue.clear();
                }
            } else if (m instanceof CloseMarker) {
                CloseMarker closeM = (CloseMarker)m;
                TagMarker lastTag = stack.size() > 0 ? (TagMarker)stack.get(0) : null;
                TagType targetType = closeM.getTargetType();
                try {
                    switch (targetType) {
                        case JCXBLOCK: {
                            if (!(lastTag instanceof JcxBlockMarker)) {
                                throw new Exception();
                            }
                            break;
                        }
                        case JCXSPAN: {
                            if (!(lastTag instanceof JcxSpanMarker)) {
                                throw new Exception();
                            }
                            break;
                        }
                        case BLOCK: {
                            if (!(lastTag instanceof BlockMarker)) {
                                throw new Exception();
                            }
                            break;
                        }
                        case INLINE: {
                            if (!(lastTag instanceof InlineMarker)) {
                                throw new Exception();
                            }
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected target tag type: " + (Object)((Object)targetType));
                        }
                    }
                }
                catch (Exception e) {
                    throw new CreoleParseException("Tangled tag nesting.  No matching open " + (Object)((Object)targetType) + " tag for close of " + closeM + ".  Last open tag is " + lastTag + '.', e);
                }
                if (lastTag.isAtomic()) {
                    throw new CreoleParseException("Close tag " + closeM + " attempted to close atomic tag " + lastTag + '.');
                }
                if (!(lastTag instanceof JcxSpanMarker || lastTag instanceof JcxBlockMarker || lastTag instanceof BlockMarker || lastTag instanceof InlineMarker)) {
                    throw new RuntimeException("Unexpected class for TagMarker " + lastTag + ": " + lastTag.getClass().getName());
                }
                if (lastTag instanceof JcxSpanMarker) {
                    prevJcxSpan = (JcxSpanMarker)lastTag;
                    typedStack = jcxSpanStack;
                } else if (lastTag instanceof JcxBlockMarker) {
                    prevJcxBlock = (JcxBlockMarker)lastTag;
                    typedStack = jcxBlockStack;
                } else if (lastTag instanceof BlockMarker) {
                    prevBlock = (BlockMarker)lastTag;
                    typedStack = blockStack;
                } else if (lastTag instanceof InlineMarker) {
                    prevInline = (InlineMarker)lastTag;
                    typedStack = inlineStack;
                }
                if (typedStack.size() < 1 || typedStack.get(0) != lastTag) {
                    throw new CreoleParseException("Closing tag " + lastTag + ", but it is not on the tail of the " + "type-specific tag stack: " + typedStack);
                }
                typedStack.remove(0);
                stack.remove(0);
            } else if (m instanceof Styler) {
                Styler styler = (Styler)m;
                TagType targetType = styler.getTargetType();
                String[] classNames = styler.getClassNames();
                switch (targetType) {
                    case JCXBLOCK: 
                    case JCXSPAN: 
                    case BLOCK: 
                    case INLINE: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected tag type value: " + (Object)((Object)targetType));
                    }
                }
                TagMarker targetTag = null;
                switch (styler.getTargetDirection()) {
                    case PREVIOUS: {
                        switch (targetType) {
                            case INLINE: {
                                targetTag = prevInline;
                                break;
                            }
                            case BLOCK: {
                                targetTag = prevBlock;
                                break;
                            }
                            case JCXSPAN: {
                                targetTag = prevJcxSpan;
                                break;
                            }
                            case JCXBLOCK: {
                                targetTag = prevJcxBlock;
                            }
                        }
                        if (targetTag != null) break;
                        throw new CreoleParseException("No previous " + (Object)((Object)targetType) + " tag for Styler " + styler);
                    }
                    case CONTAINER: {
                        switch (targetType) {
                            case INLINE: {
                                typedStack = inlineStack;
                                break;
                            }
                            case BLOCK: {
                                typedStack = blockStack;
                                break;
                            }
                            case JCXSPAN: {
                                typedStack = jcxSpanStack;
                                break;
                            }
                            case JCXBLOCK: {
                                typedStack = jcxBlockStack;
                            }
                        }
                        if (typedStack.size() < 1) {
                            throw new CreoleParseException("No parent " + (Object)((Object)targetType) + " container for Styler " + styler);
                        }
                        targetTag = (TagMarker)typedStack.get(0);
                        break;
                    }
                    case NEXT: {
                        switch (targetType) {
                            case INLINE: {
                                typedQueue = queuedInlineClassNames;
                                break;
                            }
                            case BLOCK: {
                                typedQueue = queuedBlockClassNames;
                                break;
                            }
                            case JCXSPAN: {
                                typedQueue = queuedJcxSpanClassNames;
                                break;
                            }
                            case JCXBLOCK: {
                                typedQueue = queuedJcxBlockClassNames;
                            }
                        }
                        typedQueue.addAll(Arrays.asList(classNames));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected direction value: " + (Object)((Object)styler.getTargetDirection()));
                    }
                }
                if (targetTag != null) {
                    targetTag.addCssClasses(classNames);
                }
            } else if (m instanceof LinkMarker) {
                LinkMarker linkM = (LinkMarker)m;
                String linkText = linkM.getLinkText();
                String lookedUpLabel = this.idToTextHMap.get(linkM.getLinkText().substring(1));
                if (linkM.getLabel() == null) {
                    linkM.setLabel(lookedUpLabel == null ? linkM.getLinkText() : lookedUpLabel);
                }
                if (lookedUpLabel == null) {
                    linkM.wrapLabel("<span class=\"jcreole_orphanLink\">", "</span>");
                }
            } else if (m instanceof TocMarker) {
                ((TocMarker)m).setSectionHeadings(this.sections);
            } else if (!(m instanceof BodyUpdaterMarker || m instanceof FootNoteRefMarker || m instanceof IndexedMarker || m instanceof DeferredUrlMarker)) {
                throw new CreoleParseException("Unexpected close marker class: " + m.getClass().getName());
            }
            if (!(m instanceof HeadingMarker)) continue;
            HeadingMarker headingM = (HeadingMarker)m;
            SectionHeading sh = headingM.getSectionHeading();
            this.enumerationFormats = headingM.updatedEnumerationFormats(this.enumerationFormats);
            sh.setEnumerationFormats(this.enumerationFormats);
            this.sections.add(sh);
            int newLevel = sh.getLevel();
            if (newLevel > headingLevel) {
                headingLevel = newLevel;
            } else if (newLevel < headingLevel) {
                for (int i = headingLevel; i > newLevel; --i) {
                    curSequences[i - 1] = -1;
                }
                headingLevel = newLevel;
            }
            if (headingM.getFormatReset() != null) {
                curSequences[headingLevel - 1] = -1;
            }
            int n = headingLevel - 1;
            curSequences[n] = curSequences[n] + 1;
            sh.setSequences(curSequences);
        }
        if (stack.size() != 0) {
            throw new CreoleParseException("Unmatched tag(s) generated: " + stack);
        }
        if (jcxSpanStack.size() != 0) {
            throw new CreoleParseException("Unmatched JCX Span tag(s): " + jcxSpanStack);
        }
        if (blockStack.size() != 0) {
            throw new CreoleParseException("Unmatched Block tag(s): " + blockStack);
        }
        if (jcxBlockStack.size() != 0) {
            throw new CreoleParseException("Unmatched JCX Block tag(s): " + jcxBlockStack);
        }
        if (inlineStack.size() != 0) {
            throw new CreoleParseException("Unmatched Inline tag(s): " + inlineStack);
        }
        if (queuedJcxSpanClassNames.size() > 0) {
            throw new CreoleParseException("Unapplied Styler JCX class names: " + queuedJcxSpanClassNames);
        }
        if (queuedJcxBlockClassNames.size() > 0) {
            throw new CreoleParseException("Unapplied Styler JCX Block class names: " + queuedBlockClassNames);
        }
        if (queuedBlockClassNames.size() > 0) {
            throw new CreoleParseException("Unapplied Styler Block class names: " + queuedBlockClassNames);
        }
        if (queuedInlineClassNames.size() > 0) {
            throw new CreoleParseException("Unapplied Styler Inline class names: " + queuedInlineClassNames);
        }
    }

    public Sections getSectionHeadings() {
        return this.sections;
    }
}

