/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

public class SectionHeading {
    public static final int MAX_LEVEL = 6;
    private final String text;
    private final String xmlId;
    private final int level;
    private int[] sequences = new int[]{-1, -1, -1, -1, -1, -1};
    private String enumerationFormats;

    public String getXmlId() {
        return this.xmlId;
    }

    public SectionHeading(String xmlId, int level, String text) {
        if (level < 1 || level > 6) {
            throw new IllegalArgumentException("Unsupported heading level: " + level);
        }
        this.xmlId = xmlId;
        this.level = level;
        this.text = text;
    }

    public void setEnumerationFormats(String enumerationFormats) {
        if (enumerationFormats == null) {
            throw new NullPointerException("enumerationFormats may not be null");
        }
        this.enumerationFormats = enumerationFormats;
    }

    public void setSequences(int[] sequences) {
        System.arraycopy(sequences, 0, this.sequences, 0, sequences.length);
    }

    public String toString() {
        return String.format("%s=> %d/%d %s \"%s\"", this.xmlId, this.level, this.sequences[this.level - 1], this.getDottedSequenceLabel(), this.text);
    }

    public int getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public String getSequenceLabel() {
        return this.getSequenceLabel(this.level);
    }

    public String getDottedSequenceLabel() {
        String segment = this.getSequenceLabel();
        if (segment == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(segment);
        for (int i = this.level - 1; i > 0; --i) {
            segment = this.getSequenceLabel(i);
            if (segment == null) continue;
            sb.insert(0, '.').insert(0, segment);
        }
        return sb.toString();
    }

    public String getSequenceLabel(int aLevel) {
        if (this.enumerationFormats == null) {
            throw new IllegalStateException("enumerationFormats is null");
        }
        if (this.enumerationFormats.length() < aLevel) {
            throw new IllegalStateException("enumerationFormats is of insufficient length: " + this.enumerationFormats.length() + " vs. " + aLevel);
        }
        char labelType = this.enumerationFormats.charAt(aLevel - 1);
        switch (labelType) {
            case '_': 
            case 'x': {
                return null;
            }
            case 'a': {
                return Character.toString((char)(97 + this.sequences[aLevel - 1]));
            }
            case 'A': {
                return Character.toString((char)(65 + this.sequences[aLevel - 1]));
            }
            case '0': {
                return Integer.toString(this.sequences[aLevel - 1]);
            }
            case '1': {
                return Integer.toString(this.sequences[aLevel - 1] + 1);
            }
        }
        throw new IllegalArgumentException("Unexpected label type: " + labelType);
    }
}

