/*
 * Decompiled with CFR 0.152.
 */
package com.admc.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Expander {
    private PairedDelims pairedDelims;
    private static Pattern anyIllegalCharPattern = Pattern.compile(".*[^.\\w].*");
    private static Pattern illegalCharPattern = Pattern.compile("[^.\\w]");
    private Map<String, String> map = new HashMap<String, String>();
    private char prefixDelimiter = (char)124;

    public Expander(PairedDelims pd) {
        this.pairedDelims = pd;
    }

    public void setPrefixDelimiter(char newDelimiter) {
        this.prefixDelimiter = newDelimiter;
    }

    private Map<String, String> getMap() {
        return new HashMap<String, String>(this.map);
    }

    public String put(String newKey, String newVal) {
        return this.put(null, newKey, newVal, true);
    }

    public String put(String newKey, String newVal, boolean expandVal) {
        return this.put(null, newKey, newVal, expandVal);
    }

    public String put(String ns, String newKey, String newVal, boolean expandVal) {
        String key;
        if (ns != null && anyIllegalCharPattern.matcher(ns).matches()) {
            throw new IllegalArgumentException("Specified namespache contains illegal character(s): " + ns);
        }
        String prefix = ns == null ? "" : ns + this.prefixDelimiter;
        String retVal = null;
        if (anyIllegalCharPattern.matcher(newKey).matches()) {
            retVal = key = illegalCharPattern.matcher(newKey).replaceAll("_");
        } else {
            key = newKey;
        }
        this.map.put(prefix + key, expandVal ? this.expand(newVal).toString() : newVal);
        return retVal;
    }

    public Map<String, String> putAll(Map<String, String> inMap) {
        return this.putAll(null, inMap, true);
    }

    public Map<String, String> putAll(Map<String, String> inMap, boolean expandVals) {
        return this.putAll(null, inMap, expandVals);
    }

    public Map<String, String> putAll(String ns, Properties ps, boolean expandVals) {
        HashMap<String, String> renameMap = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : ps.entrySet()) {
            String changedKey = this.put(ns, entry.getKey().toString(), entry.getValue().toString(), expandVals);
            if (changedKey == null) continue;
            renameMap.put(entry.getKey().toString(), changedKey);
        }
        return renameMap;
    }

    public Map<String, String> putAll(String ns, Map<String, String> inMap, boolean expandVals) {
        HashMap<String, String> renameMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : inMap.entrySet()) {
            String changedKey = this.put(ns, entry.getKey(), entry.getValue(), expandVals);
            if (changedKey == null) continue;
            renameMap.put(entry.getKey(), changedKey);
        }
        return renameMap;
    }

    public String expandToString(CharSequence inString) {
        return this.expand(inString).toString();
    }

    public synchronized StringBuilder expand(CharSequence inString) {
        HashSet<String> throwRefs = new HashSet<String>();
        CharSequence seq = this.pairedDelims.preserveEscapes(inString);
        Matcher matcher = this.pairedDelims.refPattern.matcher(seq);
        int prevEnd = 0;
        StringBuilder sb = new StringBuilder();
        block4: while (matcher.find()) {
            if (throwRefs.size() < 1) {
                sb.append(seq.subSequence(prevEnd, matcher.start()));
            }
            prevEnd = matcher.end();
            if (this.map.containsKey(matcher.group(2))) {
                if (throwRefs.size() >= 1) continue;
                sb.append(this.map.get(matcher.group(2)));
                continue;
            }
            if (matcher.group(1) == null) {
                if (throwRefs.size() >= 1) continue;
                sb.append(matcher.group(0));
                continue;
            }
            switch (matcher.group(1).charAt(0)) {
                case '!': {
                    throwRefs.add(matcher.group(2));
                    continue block4;
                }
                case '-': {
                    continue block4;
                }
            }
            throw new RuntimeException("Unexpected behavior pref string: " + matcher.group(1));
        }
        if (throwRefs.size() > 0) {
            throw new IllegalArgumentException("Unsatisfied ! reference(s): " + throwRefs);
        }
        sb.append(seq.subSequence(prevEnd, seq.length()));
        this.pairedDelims.escape(sb);
        return sb;
    }

    public static void main(String[] sa) {
        System.out.println(new Expander(PairedDelims.CURLY).expand(sa[0]));
    }

    public String toString() {
        return this.map.toString();
    }

    public static enum PairedDelims {
        CURLY('{', "\\$\\{([-!])?([^}\\{]+)\\}"),
        RECTANGULAR('[', "\\$\\[([-!])?([^]\\[]+)\\]"),
        ROUNDED('(', "\\$\\(([-!])?([^)\\(]+)\\)");

        public final Pattern refPattern;
        final String escapeFrom;
        final String escapeTo;

        private PairedDelims(char lChar, String s) {
            this.refPattern = Pattern.compile(s);
            this.escapeFrom = "\\$" + lChar;
            this.escapeTo = "$" + lChar;
        }

        public CharSequence preserveEscapes(CharSequence s) {
            if (s instanceof String) {
                if (((String)s).indexOf(this.escapeFrom) < 0) {
                    return s;
                }
                return ((String)s).replace(this.escapeFrom, "\u0002");
            }
            if (!(s instanceof StringBuilder)) {
                throw new RuntimeException("CharSequence.preserveEscapes only works with Strings and StringBuilders");
            }
            StringBuilder sb = (StringBuilder)s;
            int lastI;
            while ((lastI = sb.lastIndexOf(this.escapeFrom)) >= 0) {
                sb.replace(lastI, lastI + 3, "\u0002");
            }
            return sb;
        }

        public void escape(StringBuilder sb) {
            int lastI;
            while ((lastI = sb.lastIndexOf("\u0002")) >= 0) {
                sb.replace(lastI, lastI + 1, this.escapeTo);
            }
            return;
        }
    }
}

