/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.DictionaryComparator;
import com.admc.jcreole.EntryOrdering;
import com.admc.jcreole.marker.BodyUpdaterMarker;
import com.admc.jcreole.marker.Entry;
import com.admc.jcreole.marker.IndexedMarker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexMarker
extends BodyUpdaterMarker {
    public List<IndexedMarker> refMarkers = new ArrayList<IndexedMarker>();
    public Map<Entry, List<IndexedMarker>> entryLinks = new HashMap<Entry, List<IndexedMarker>>();

    public void add(IndexedMarker refMarker) {
        this.refMarkers.add(refMarker);
    }

    public IndexMarker(int id, EntryOrdering inOrdering) {
        super(id, inOrdering == null ? EntryOrdering.NAME_BY_DICTIONARY : inOrdering);
        if (this.ordering == EntryOrdering.DEF_ORDER) {
            throw new CreoleParseException("Ordering not supported for FootNotes: " + (Object)((Object)this.ordering));
        }
    }

    public void generateEntries() {
        int counter = 0;
        for (IndexedMarker refMarker : this.refMarkers) {
            Entry entry;
            if (this.origKeyToEntry.containsKey(refMarker.getName())) {
                entry = (Entry)this.origKeyToEntry.get(refMarker.getName());
            } else {
                entry = new Entry(1 + this.entries.size());
                entry.setLabel(refMarker.getName());
                this.entryLinks.put(entry, new ArrayList());
                this.entries.add(entry);
                this.origKeyToEntry.put(refMarker.getName(), entry);
            }
            this.entryLinks.get(entry).add(refMarker);
            refMarker.setTargNum(++counter);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Entry, List<IndexedMarker>> e : this.entryLinks.entrySet()) {
            sb.setLength(0);
            int refCount = 0;
            for (IndexedMarker refMarker : e.getValue()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append("<a href=\"#jcindexed").append(refMarker.getTargNum()).append("\">").append(++refCount).append("</a>");
            }
            e.getKey().setHtml(sb.toString());
        }
    }

    @Override
    public void updateBuffer() {
        for (Entry entry : this.entries) {
            this.outBuffer.append(entry.toHtml(null));
        }
        super.updateBuffer();
    }

    @Override
    public void sort() {
        switch (this.ordering) {
            case REF_ORDER: {
                break;
            }
            case NAME_BY_DICTIONARY: {
                Collections.sort(this.entries, DictionaryComparator.singleton);
                break;
            }
            case NAME_BY_JAVA: {
                Collections.sort(this.entries);
            }
        }
    }
}

