/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.CreoleParser;
import com.admc.jcreole.TagType;
import com.admc.jcreole.marker.BufferMarker;
import java.util.regex.Matcher;

public class Styler
extends BufferMarker {
    protected String[] classNames;
    protected Direction targetDirection;
    protected TagType targetType;

    public Styler(int id, String newClassNames, char directionChar, String tagTypeStr) {
        super(id);
        if (newClassNames == null) {
            throw new NullPointerException("Styler specifies no CSS class names");
        }
        Matcher m = CreoleParser.CssNamesPattern.matcher(newClassNames);
        if (!m.matches()) {
            throw new CreoleParseException("Malformatted class name(s): " + newClassNames);
        }
        this.classNames = newClassNames.split("\\s+", -1);
        switch (directionChar) {
            case '-': {
                this.targetDirection = Direction.PREVIOUS;
                break;
            }
            case '=': {
                this.targetDirection = Direction.CONTAINER;
                break;
            }
            case '+': {
                this.targetDirection = Direction.NEXT;
                break;
            }
            default: {
                throw new CreoleParseException("Unexpected target direction specifier character: " + directionChar);
            }
        }
        this.targetType = Enum.valueOf(TagType.class, tagTypeStr.toUpperCase());
        if (this.targetType == null) {
            throw new CreoleParseException("Unexpected tag type specifier: " + tagTypeStr);
        }
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public Direction getTargetDirection() {
        return this.targetDirection;
    }

    public TagType getTargetType() {
        return this.targetType;
    }

    static enum Direction {
        PREVIOUS,
        CONTAINER,
        NEXT;

    }
}

