/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

public abstract class BufferMarker
implements Comparable<BufferMarker> {
    protected int offset = -1;
    protected int id = -1;
    protected StringBuilder targetSb;
    public static final char markerChar = '\u001a';
    protected boolean applied;

    public String toString() {
        return this.getIdString() + '@' + this.offset;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BufferMarker)) {
            return false;
        }
        return this.compareTo((BufferMarker)o) == 0;
    }

    @Override
    public int compareTo(BufferMarker other) {
        if (this == other) {
            return 0;
        }
        if (this.offset < 0 && other.offset < 0) {
            return Integer.valueOf(this.id).compareTo(other.id);
        }
        return Integer.valueOf(this.offset).compareTo(other.offset);
    }

    protected BufferMarker(int id) {
        this.id = id;
        if (id < 0 || id > 65535) {
            throw new IllegalArgumentException("Id is not between 0 and 0xFFFF inclusive: " + id);
        }
    }

    public String getIdString() {
        return String.format("%04X", this.id);
    }

    public String getMarkerString() {
        return Character.toString('\u001a') + this.getIdString();
    }

    public int getOffset() {
        return this.offset;
    }

    public void validate() {
        if (this.targetSb == null || this.offset < 1) {
            throw new IllegalStateException("targetSb or offset not initialized");
        }
        if (this.targetSb.length() < this.offset + 4) {
            throw new IllegalStateException("StringBuilder not long enough to contain marker at " + this.offset);
        }
        if (this.targetSb.charAt(this.offset) != '\u001a') {
            throw new IllegalStateException("Missing binary SUB char at offset " + this.offset);
        }
        if (!this.targetSb.substring(this.offset + 1, this.offset + 5).equals(this.getIdString())) {
            throw new IllegalStateException("Marker ID mismatch.  Expected " + this.getIdString() + " but is '" + this.targetSb.substring(this.offset + 1, this.offset + 5) + "'");
        }
    }

    public void setContext(StringBuilder targetSb, int offset) {
        this.targetSb = targetSb;
        this.offset = offset;
        this.validate();
    }

    public void updateBuffer() {
        if (this.applied) {
            throw new IllegalStateException("This marker already applied: " + this);
        }
        this.validate();
        this.targetSb.delete(this.offset, this.offset + 5);
    }
}

