/*
 * Decompiled with CFR 0.152.
 */
package com.admc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOUtil {
    private static Log log = LogFactory.getLog(IOUtil.class);

    private IOUtil() {
    }

    public static String toString(File file) throws IOException {
        return IOUtil.toString(new FileInputStream(file), 10240);
    }

    public static StringBuilder toStringBuilder(File file) throws IOException {
        return IOUtil.toStringBuilder(new FileInputStream(file), 10240);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IOUtil.toString(inputStream, 10240);
    }

    public static String toString(InputStream inputStream, int bufferChars) throws IOException {
        return IOUtil.toStringBuilder(inputStream, bufferChars).toString();
    }

    public static StringBuilder toStringBuilder(InputStream inputStream) throws IOException {
        return IOUtil.toStringBuilder(inputStream, 10240);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder toStringBuilder(InputStream inputStream, int bufferChars) throws IOException {
        char[] buffer = new char[bufferChars];
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        try {
            int i;
            while ((i = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, i);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                log.error("Failed to close reader", ioe);
            }
            reader = null;
        }
        return sb;
    }
}

