/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import beaver.Parser;
import com.admc.jcreole.CreoleParseException;
import com.admc.jcreole.CreoleParser;
import com.admc.jcreole.CreoleScanner;
import com.admc.jcreole.InterWikiMapper;
import com.admc.jcreole.JCreolePrivilege;
import com.admc.jcreole.WashedSymbol;
import com.admc.util.Expander;
import com.admc.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCreole {
    private static Log log = LogFactory.getLog(JCreole.class);
    private static final String DEFAULT_BP_RES_PATH = "boilerplate-inet.html";
    private static SimpleDateFormat isoDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    public static final String SYNTAX_MSG = "java -jar .../jcreole-*.jar [-d] [-] [-r /classpath/boiler.html] [-f fs/boiler.html] [-o fspath/out.html] pathto/input.creole\n\nThe -, -r, and -f options are mutually exclusive.\n  NONE:      Default built-in boilerplate (\"boilerplate-inet.html\").\n  -:         No boilerplate.  Output will be just a HTML fragment.\n  -r path:   Load specified boilerplate file from Classpath.\n             Example:  -r /boilerplate-standalone.html\n  -f path:   Load specified boilerplate file from file system.\n  -d option: Loads an IntraWiki-link debug mapper and a sample\n             creoleMapper from 'testMacro'.\n  -t:        Troubleshoot failing Creole input.\n             This does not output HTML but reports on likely error location.  Best effort that doesn't work with some paired tags.\nIf either -r or -f is specified, the specified boilerplate should include\n'$(pageContent)' at the point(s) where you want content generated from your Creole\ninserted.\nIf the outputfile already exists, it will be silently overwritten.\nThe input Creole file is sought first in the classpath (relative to classpath\nroots) then falls back to looking for a filesystem file.\nOutput is always written with UTF-8 encoding.";
    protected CreoleParser parser = new CreoleParser();
    private CharSequence pageBoilerPlate;
    private Expander creoleExpander;
    private Expander htmlExpander = new Expander(Expander.PairedDelims.CURLY);
    private List<String> cssHrefs;
    private Expander framingExpander = new Expander(Expander.PairedDelims.ROUNDED);

    public Expander getFramingExpander() {
        return this.framingExpander;
    }

    public Expander getHtmlExpander() {
        return this.htmlExpander;
    }

    public static void main(String[] sa) throws IOException {
        JCreole jCreole;
        String bpResPath = null;
        String bpFsPath = null;
        String outPath = null;
        String inPath = null;
        boolean debugs = false;
        boolean troubleshoot = false;
        boolean noBp = false;
        int param = -1;
        try {
            while (++param < sa.length) {
                if (sa[param].equals("-d")) {
                    debugs = true;
                    continue;
                }
                if (sa[param].equals("-t")) {
                    troubleshoot = true;
                    continue;
                }
                if (sa[param].equals("-r") && param + 1 < sa.length) {
                    if (bpFsPath != null || bpResPath != null || noBp) {
                        throw new IllegalArgumentException();
                    }
                    bpResPath = sa[++param];
                    continue;
                }
                if (sa[param].equals("-f") && param + 1 < sa.length) {
                    if (bpResPath != null || bpFsPath != null || noBp) {
                        throw new IllegalArgumentException();
                    }
                    bpFsPath = sa[++param];
                    continue;
                }
                if (sa[param].equals("-")) {
                    if (noBp || bpFsPath != null || bpResPath != null) {
                        throw new IllegalArgumentException();
                    }
                    noBp = true;
                    continue;
                }
                if (sa[param].equals("-o") && param + 1 < sa.length) {
                    if (outPath != null) {
                        throw new IllegalArgumentException();
                    }
                    outPath = sa[++param];
                    continue;
                }
                if (inPath != null) {
                    throw new IllegalArgumentException();
                }
                inPath = sa[param];
            }
            if (inPath == null) {
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException iae) {
            System.err.println(SYNTAX_MSG);
            System.exit(1);
        }
        if (!noBp && bpResPath == null && bpFsPath == null) {
            bpResPath = DEFAULT_BP_RES_PATH;
        }
        String rawBoilerPlate = null;
        if (bpResPath != null) {
            InputStream iStream;
            if (bpResPath.length() > 0 && bpResPath.charAt(0) == '/') {
                bpResPath = bpResPath.substring(1);
            }
            if ((iStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(bpResPath)) == null) {
                throw new IOException("Boilerplate inaccessible: " + bpResPath);
            }
            rawBoilerPlate = IOUtil.toString(iStream);
        } else if (bpFsPath != null) {
            rawBoilerPlate = IOUtil.toString(new File(bpFsPath));
        }
        String creoleResPath = inPath.length() > 0 && inPath.charAt(0) == '/' ? inPath.substring(1) : inPath;
        InputStream creoleStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(creoleResPath);
        File inFile = creoleStream == null ? new File(inPath) : null;
        JCreole jCreole2 = jCreole = rawBoilerPlate == null ? new JCreole() : new JCreole(rawBoilerPlate);
        if (debugs) {
            jCreole.setInterWikiMapper(new InterWikiMapper(){

                @Override
                public String toPath(String wikiName, String wikiPage) {
                    if (wikiName != null && wikiName.equals("nil")) {
                        return null;
                    }
                    return "{WIKI-LINK to: " + wikiName + '|' + wikiPage + '}';
                }

                @Override
                public String toLabel(String wikiName, String wikiPage) {
                    if (wikiPage == null) {
                        throw new RuntimeException("Null page name sent to InterWikiMapper");
                    }
                    if (wikiPage.equals("nil")) {
                        return null;
                    }
                    return "{LABEL for: " + wikiName + '|' + wikiPage + '}';
                }
            });
            Expander creoleExpander = new Expander(Expander.PairedDelims.RECTANGULAR);
            creoleExpander.put("testMacro", "\n\n<<prettyPrint>>\n{{{\n!/bin/bash -p\n\ncp /etc/inittab /tmp\n}}}\n");
            jCreole.setCreoleExpander(creoleExpander);
        }
        jCreole.setPrivileges(EnumSet.allOf(JCreolePrivilege.class));
        Expander exp = jCreole.getHtmlExpander();
        Date now = new Date();
        exp.putAll("sys", System.getProperties(), false);
        exp.put("isoDateTime", isoDateTimeFormatter.format(now), false);
        exp.put("isoDate", isoDateFormatter.format(now), false);
        exp.put("pageTitle", inFile == null ? creoleResPath.replaceFirst("[.][^.]*$", "").replaceFirst(".*[/\\\\.]", "") : inFile.getName().replaceFirst("[.][^.]*$", ""));
        if (troubleshoot) {
            StringBuilder builder = creoleStream == null ? IOUtil.toStringBuilder(inFile) : IOUtil.toStringBuilder(creoleStream);
            int newlineCount = 0;
            int lastOffset = -1;
            int offset = builder.indexOf("\n");
            while (offset >= 0) {
                lastOffset = offset;
                ++newlineCount;
                offset = builder.indexOf("\n", offset + 1);
            }
            if (builder.length() > lastOffset + 1) {
                ++newlineCount;
            }
            System.out.println("Input lines:  " + newlineCount);
            Exception lastException = null;
            while (true) {
                try {
                    jCreole.parseCreole(builder);
                }
                catch (Exception e) {
                    lastException = e;
                    if (builder.charAt(builder.length() - 1) == '\n') {
                        builder.setLength(builder.length() - 1);
                    }
                    if ((offset = builder.lastIndexOf("\n")) < 1) break;
                    --newlineCount;
                    builder.setLength(builder.lastIndexOf("\n"));
                    continue;
                }
                break;
            }
            System.out.println(lastException == null ? "Input validates" : String.format("Error around input line %d:  %s", newlineCount, lastException.getMessage()));
            return;
        }
        String generatedHtml = creoleStream == null ? jCreole.parseCreole(inFile) : jCreole.parseCreole(IOUtil.toStringBuilder(creoleStream));
        String html = jCreole.postProcess(generatedHtml, SystemUtils.LINE_SEPARATOR);
        if (outPath == null) {
            System.out.print(html);
        } else {
            FileUtils.writeStringToFile(new File(outPath), html, "UTF-8");
        }
    }

    public JCreole() {
    }

    public JCreole(String rawBoilerPlate) {
        if (rawBoilerPlate.indexOf("$(pageContent)") < 0 && rawBoilerPlate.indexOf("$(!pageContent)") < 0) {
            throw new IllegalArgumentException("Boilerplate contains neither $(pageContent) nor $(!pageContent)");
        }
        this.pageBoilerPlate = rawBoilerPlate.replace("\r", "");
    }

    public String parseCreole(StringBuilder sb) throws IOException {
        if (sb == null || sb.length() < 1) {
            throw new IllegalArgumentException("No input supplied");
        }
        CreoleScanner scanner = CreoleScanner.newCreoleScanner(sb, true, this.creoleExpander);
        Object retVal = null;
        try {
            retVal = this.parser.parse(scanner);
        }
        catch (CreoleParseException cpe) {
            throw cpe;
        }
        catch (Parser.Exception bpe) {
            throw new CreoleParseException(bpe);
        }
        catch (RuntimeException rte) {
            log.error("Unexpected problem.  Passing RuntimeException to caller", rte);
            throw new CreoleParseException("Unexpected problem", rte);
        }
        if (!(retVal instanceof WashedSymbol)) {
            log.error("Parser returned unexpected type " + retVal.getClass().getName() + ".  Throwing RTE.");
            throw new IllegalStateException("Parser returned unexpected type: " + retVal.getClass().getName());
        }
        return ((WashedSymbol)((Object)retVal)).toString();
    }

    public String parseCreole(File creoleFile) throws IOException {
        if (creoleFile == null || creoleFile.length() < 1L) {
            throw new IllegalArgumentException("No input supplied");
        }
        CreoleScanner scanner = CreoleScanner.newCreoleScanner(creoleFile, false, this.creoleExpander);
        Object retVal = null;
        try {
            retVal = this.parser.parse(scanner);
        }
        catch (CreoleParseException cpe) {
            throw cpe;
        }
        catch (Parser.Exception bpe) {
            throw new CreoleParseException(bpe);
        }
        if (!(retVal instanceof WashedSymbol)) {
            throw new IllegalStateException("Parser returned unexpected type: " + retVal.getClass().getName());
        }
        return ((WashedSymbol)((Object)retVal)).toString();
    }

    public String postProcess(String htmlFrag, String outputEol) throws IOException {
        String htmlString = null;
        if (this.pageBoilerPlate == null) {
            htmlString = htmlFrag;
        } else {
            StringBuilder html = new StringBuilder(this.pageBoilerPlate);
            if (html.indexOf("$(pageHeaders)") > -1 || html.indexOf("$(!pageHeaders)") > -1) {
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (String href : this.getCssHrefs()) {
                    sb.append(String.format("<link id=\"auto%02d\" class=\"auto\" rel=\"stylesheet\" type=\"text/css\" href=\"%s\" />\n", ++count, href));
                }
                this.framingExpander.put("pageHeaders", sb.toString(), false);
            } else if (this.getCssHrefs().size() > 0) {
                throw new CreoleParseException("Author-supplied style-sheets, but boilerplate has no 'pageHeaders' insertion-point");
            }
            this.framingExpander.put("pageContent", htmlFrag, false);
            htmlString = this.framingExpander.expand(html).toString();
        }
        if (outputEol != null && !outputEol.equals("\n")) {
            htmlString = htmlString.replace("\n", outputEol);
        }
        return this.htmlExpand(htmlString);
    }

    public String htmlExpand(String htmlString) {
        return this.htmlExpander.expandToString(htmlString);
    }

    public void setCreoleExpander(Expander creoleExpander) {
        this.creoleExpander = creoleExpander;
    }

    public void setPrivileges(EnumSet<JCreolePrivilege> jcreolePrivs) {
        this.parser.setPrivileges(jcreolePrivs);
    }

    public void setEnumerationFormats(String enumerationFormats) {
        this.parser.setEnumSymbols(enumerationFormats, true);
    }

    public void setEnumSymbols(String symbolString, boolean forSection) {
        this.parser.setEnumSymbols(symbolString, forSection);
    }

    public EnumSet<JCreolePrivilege> getPrivileges() {
        return this.parser.getPrivileges();
    }

    public void setInterWikiMapper(InterWikiMapper interWikiMapper) {
        this.parser.setInterWikiMapper(interWikiMapper);
    }

    public CreoleParser getParser() {
        return this.parser;
    }

    public List<String> getCssHrefs() {
        ArrayList<String> outCssHrefs = this.cssHrefs == null ? new ArrayList<String>() : new ArrayList<String>(this.cssHrefs);
        outCssHrefs.addAll(this.parser.getCssHrefs());
        return outCssHrefs;
    }

    public void addCssHrefs(List<String> newCssHrefs) {
        this.cssHrefs = new ArrayList<String>(newCssHrefs);
    }

    public void setHtmlExpander(Expander htmlExpander) {
        this.htmlExpander = htmlExpander;
    }
}

