/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole.marker;

import com.admc.jcreole.DictionaryComparator;
import com.admc.jcreole.EntryOrdering;
import com.admc.jcreole.marker.BodyUpdaterMarker;
import com.admc.jcreole.marker.DeferredUrlMarker;
import com.admc.jcreole.marker.Entry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class MasterDefListMarker
extends BodyUpdaterMarker {
    public List<DeferredUrlMarker> refMarkers = new ArrayList<DeferredUrlMarker>();

    public void add(DeferredUrlMarker refMarker) {
        this.refMarkers.add(refMarker);
    }

    public void updateReferences() {
        for (DeferredUrlMarker refMarker : this.refMarkers) {
            Entry targetEntry = (Entry)this.origKeyToEntry.get(refMarker.getInUrl());
            if (targetEntry == null) continue;
            refMarker.setTargetId(targetEntry.getEntryId());
        }
    }

    public MasterDefListMarker(int id, EntryOrdering inOrdering) {
        super(id, inOrdering == null ? EntryOrdering.NAME_BY_DICTIONARY : inOrdering);
    }

    public void add(String name) {
        Entry newEntry = new Entry(1 + this.entries.size());
        this.entries.add(newEntry);
        this.origKeyToEntry.put(name, newEntry);
        newEntry.setLabel(name);
    }

    public void set(String name, String entryHtml) {
        Entry targetEntry = (Entry)this.origKeyToEntry.get(name);
        if (targetEntry == null) {
            throw new IllegalArgumentException("Lost MasterDefList entry for: " + name);
        }
        targetEntry.setHtml(entryHtml);
    }

    @Override
    public void updateBuffer() {
        for (Entry entry : this.entries) {
            this.outBuffer.append(entry.toHtml("jcmdef"));
        }
        super.updateBuffer();
    }

    @Override
    public void sort() {
        switch (this.ordering) {
            case DEF_ORDER: {
                break;
            }
            case REF_ORDER: {
                HashSet<String> loadedNames = new HashSet<String>();
                ArrayList origEntries = new ArrayList(this.entries);
                this.entries.clear();
                for (DeferredUrlMarker refMarker : this.refMarkers) {
                    Entry targetEntry = (Entry)this.origKeyToEntry.get(refMarker.getInUrl());
                    if (targetEntry == null || loadedNames.contains(refMarker.getInUrl())) continue;
                    loadedNames.add(refMarker.getInUrl());
                    this.entries.add(targetEntry);
                    origEntries.remove(targetEntry);
                }
                this.entries.addAll(origEntries);
                break;
            }
            case NAME_BY_DICTIONARY: {
                Collections.sort(this.entries, DictionaryComparator.singleton);
                break;
            }
            case NAME_BY_JAVA: {
                Collections.sort(this.entries);
            }
        }
    }
}

