/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import com.admc.jcreole.Indexer;
import com.admc.jcreole.InterWikiMapper;
import com.admc.jcreole.JCreole;
import com.admc.jcreole.JCreolePrivilege;
import com.admc.util.Expander;
import com.admc.util.FileComparator;
import com.admc.util.IOUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CreoleToHtmlServlet
extends HttpServlet
implements InterWikiMapper {
    private static Pattern servletFilePattern = Pattern.compile("(.+)\\.html");
    private String creoleRoot = "WEB-INF/creole";
    private boolean isRootAbsolute;
    private boolean autoIndexing = true;
    private String contextPath;
    private ServletContext application;
    private Indexer indexer = new Indexer();
    private static SimpleDateFormat isoDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static Pattern sortParamPattern = Pattern.compile("([-+])(\\w+)");
    EnumSet<JCreolePrivilege> jcreolePrivs;
    protected Map<String, String> iwUrls;
    protected Map<String, String> iwLabels;

    public CreoleToHtmlServlet() {
        this.indexer.setFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String n = file.getName();
                if (n.length() < 1 || n.charAt(0) == '.') {
                    return false;
                }
                if (n.equalsIgnoreCase("web-inf")) {
                    return false;
                }
                if (n.equalsIgnoreCase("meta-inf")) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                if (!n.endsWith(".creole")) {
                    return false;
                }
                return !n.equals("index.creole");
            }
        });
        this.indexer.setNameTranslationMatchPat("(.+)\\Q.creole");
        this.indexer.setNameTranslationFormat("%1$s.html");
        this.jcreolePrivs = EnumSet.complementOf(EnumSet.of(JCreolePrivilege.RAWHTML));
        this.iwUrls = new HashMap<String, String>();
        this.iwLabels = new HashMap<String, String>();
    }

    public void init() throws ServletException {
        super.init();
        this.application = this.getServletContext();
        String creoleRootParam = this.application.getInitParameter("creoleRoot");
        if (creoleRootParam != null) {
            this.creoleRoot = creoleRootParam;
        }
        if (this.creoleRoot == null || this.creoleRoot.length() < 1) {
            throw new ServletException("Invalid 'creoleRoot': " + creoleRootParam);
        }
        this.isRootAbsolute = this.creoleRoot.charAt(0) == '/' || this.creoleRoot.charAt(0) == '\\';
        String autoString = this.application.getInitParameter("autoIndexing");
        this.autoIndexing = autoString == null || Boolean.parseBoolean(autoString);
        this.log("Using creoleRoot of '" + this.creoleRoot + "'");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        URL url;
        File tmpDir;
        StringBuilder readmeSb = null;
        File fsDirFile = null;
        ArrayList<String> cssHrefs = new ArrayList<String>();
        File servletPathFile = new File(req.getServletPath());
        if (this.contextPath == null) {
            this.contextPath = this.application.getContextPath();
            this.iwUrls.put("home", this.contextPath);
            String appName = this.application.getServletContextName();
            this.iwLabels.put("home", (appName == null ? "Site" : appName) + " Home Page");
        }
        InputStream bpStream = null;
        Matcher matcher = servletFilePattern.matcher(servletPathFile.getName());
        if (!matcher.matches()) {
            throw new ServletException("Servlet " + this.getClass().getName() + " only supports servlet paths ending with '.html':  " + servletPathFile.getAbsolutePath());
        }
        File crRootedDir = servletPathFile.getParentFile();
        String pageBaseName = matcher.group(1);
        String absUrlDirPath = this.contextPath + crRootedDir.getAbsolutePath();
        String absUrlBasePath = absUrlDirPath + '/' + pageBaseName;
        File creoleFile = new File((this.isRootAbsolute ? "" : "/") + this.creoleRoot + crRootedDir.getAbsolutePath(), pageBaseName + ".creole");
        InputStream creoleStream = null;
        InputStream inputStream = this.isRootAbsolute ? (creoleFile.isFile() ? new FileInputStream(creoleFile) : null) : (creoleStream = this.application.getResourceAsStream(creoleFile.getAbsolutePath()));
        if (this.indexer != null) {
            if (this.isRootAbsolute) {
                fsDirFile = creoleFile.getParentFile();
                if (!fsDirFile.isDirectory()) {
                    fsDirFile = null;
                }
            } else {
                fsDirFile = new File(this.application.getRealPath(creoleFile.getParentFile().getAbsolutePath()));
            }
            if (fsDirFile != null && !fsDirFile.isDirectory()) {
                throw new ServletException("fsDirFile unexpectedly not a directory: " + fsDirFile.getAbsolutePath());
            }
        }
        if (pageBaseName.equals("index")) {
            File readmeFile = new File(creoleFile.getParentFile(), "readme.creole");
            InputStream readmeStream = this.isRootAbsolute ? (readmeFile.isFile() ? new FileInputStream(readmeFile) : null) : this.application.getResourceAsStream(readmeFile.getAbsolutePath());
            readmeSb = new StringBuilder("----\n");
            if (readmeStream == null) {
                readmeSb.append("{{{\n");
                readmeStream = this.application.getResourceAsStream(new File(crRootedDir, "readme.txt").getAbsolutePath());
                if (readmeStream != null) {
                    readmeSb.append((CharSequence)IOUtil.toStringBuilder(readmeStream));
                    readmeSb.append("\n}}}\n");
                }
            } else {
                readmeSb.append((CharSequence)IOUtil.toStringBuilder(readmeStream));
            }
            if (readmeStream == null) {
                readmeSb = null;
            }
        }
        boolean inAncestorDir = false;
        for (tmpDir = crRootedDir; tmpDir != null; tmpDir = tmpDir.getParentFile()) {
            File curDir = new File((this.isRootAbsolute ? "" : "/") + this.creoleRoot + tmpDir.getAbsolutePath());
            File bpFile = new File(curDir, "boilerplate.html");
            if (bpStream == null) {
                InputStream inputStream2 = this.isRootAbsolute ? (bpFile.isFile() ? new FileInputStream(bpFile) : null) : (bpStream = this.application.getResourceAsStream(bpFile.getAbsolutePath()));
            }
            if ((url = this.application.getResource(new File(tmpDir, "site.css").getAbsolutePath())) != null) {
                cssHrefs.add(0, new File(this.contextPath + tmpDir, "site.css").getAbsolutePath());
            }
            if (creoleStream == null && inAncestorDir && pageBaseName.equals("index") && this.autoIndexing) {
                File indexFile = new File(curDir, "index.creole");
                creoleStream = this.isRootAbsolute ? (indexFile.isFile() ? new FileInputStream(indexFile) : null) : this.application.getResourceAsStream(indexFile.getAbsolutePath());
            }
            inAncestorDir = true;
        }
        if (creoleStream == null) {
            throw new ServletException("Failed to access:  " + creoleFile.getAbsolutePath());
        }
        if (bpStream == null) {
            throw new ServletException("Failed to access 'boilerplate.html' from creole dir or ancestor dir");
        }
        for (tmpDir = crRootedDir; tmpDir != null; tmpDir = tmpDir.getParentFile()) {
            url = this.application.getResource(new File(tmpDir, "jcreole.css").getAbsolutePath());
            if (url == null) continue;
            cssHrefs.add(0, new File(this.contextPath + tmpDir, "jcreole.css").getAbsolutePath());
        }
        JCreole jCreole = new JCreole(IOUtil.toString(bpStream));
        Expander htmlExpander = jCreole.getHtmlExpander();
        Date now = new Date();
        htmlExpander.put("isoDateTime", isoDateTimeFormatter.format(now), false);
        htmlExpander.put("isoDate", isoDateFormatter.format(now), false);
        htmlExpander.put("contextPath", this.contextPath, false);
        htmlExpander.put("pageBaseName", pageBaseName, false);
        htmlExpander.put("pageDirPath", absUrlDirPath, false);
        htmlExpander.put("pageTitle", absUrlBasePath, false);
        if (readmeSb == null) {
            htmlExpander.put("readmeContent", "");
        } else {
            JCreole readmeJCreole = new JCreole();
            readmeJCreole.setHtmlExpander(htmlExpander);
            readmeJCreole.setInterWikiMapper(this);
            readmeJCreole.setPrivileges(this.jcreolePrivs);
            htmlExpander.put("readmeContent", readmeJCreole.postProcess(readmeJCreole.parseCreole(readmeSb), "\n"), false);
        }
        if (fsDirFile != null) {
            FileComparator.SortBy sortBy = FileComparator.SortBy.NAME;
            boolean ascending = true;
            String sortStr = req.getParameter("sort");
            if (sortStr != null) {
                Matcher m = sortParamPattern.matcher(sortStr);
                if (!m.matches()) {
                    throw new ServletException("Malformatted sort value: " + sortStr);
                }
                ascending = m.group(1).equals("+");
                try {
                    sortBy = Enum.valueOf(FileComparator.SortBy.class, m.group(2));
                }
                catch (Exception e) {
                    throw new ServletException("Malformatted sort string: " + sortStr);
                }
            }
            htmlExpander.put("index", "\n" + this.indexer.generateTable(fsDirFile, absUrlDirPath, true, sortBy, ascending), false);
        }
        if (cssHrefs.size() > 0) {
            jCreole.addCssHrefs(cssHrefs);
        }
        jCreole.setInterWikiMapper(this);
        jCreole.setPrivileges(this.jcreolePrivs);
        String html = jCreole.postProcess(jCreole.parseCreole(IOUtil.toStringBuilder(creoleStream)), "\n");
        resp.setBufferSize(1024);
        resp.setContentType("text/html");
        resp.getWriter().print(html);
    }

    @Override
    public String toPath(String wikiName, String wikiPage) {
        if (wikiPage == null) {
            throw new RuntimeException("wiki page name not given to InterWikiMapper");
        }
        if (wikiName == null) {
            return this.iwUrls.get(wikiPage);
        }
        if (wikiName.equals("Wikipedia")) {
            return "http://en.wikipedia.org/wiki/" + wikiPage;
        }
        return null;
    }

    @Override
    public String toLabel(String wikiName, String wikiPage) {
        if (wikiPage == null) {
            throw new RuntimeException("wiki page name not given to InterWikiMapper");
        }
        if (wikiName == null) {
            return this.iwLabels.get(wikiPage);
        }
        if (wikiName.equals("Wikipedia")) {
            return wikiPage + " @ Wikipedia";
        }
        return null;
    }
}

