/*
 * Decompiled with CFR 0.152.
 */
package com.admc.util;

import java.io.File;
import java.util.Comparator;

public class FileComparator
implements Comparator<File> {
    private SortBy cfField;
    private boolean ascending;

    public FileComparator(SortBy cfField, boolean ascending) {
        this.ascending = ascending;
        this.cfField = cfField;
    }

    @Override
    public int compare(File f1, File f2) {
        int val;
        switch (this.cfField) {
            case MODIFIED: {
                long l1 = f1.lastModified();
                long l2 = f2.lastModified();
                if (l1 == l2) {
                    val = 0;
                    break;
                }
                if (l1 < l2) {
                    val = -1;
                    break;
                }
                val = 2;
                break;
            }
            case SIZE: {
                long l2;
                long l1 = f1.isDirectory() ? 0L : f1.length();
                long l = l2 = f2.isDirectory() ? 0L : f2.length();
                if (l1 == l2) {
                    val = 0;
                    break;
                }
                if (l1 < l2) {
                    val = -1;
                    break;
                }
                val = 2;
                break;
            }
            case NAME: {
                String n1 = f1.getName();
                String n2 = f2.getName();
                if (n1.length() > n2.length()) {
                    n1 = n1.substring(0, n2.length());
                } else if (n2.length() > n1.length()) {
                    n2 = n2.substring(0, n1.length());
                }
                val = n1.compareToIgnoreCase(n2);
                if (val < 0) {
                    val = -1;
                    break;
                }
                if (val > 0) {
                    val = 1;
                    break;
                }
                val = -n1.compareTo(n2);
                if (val != 0) break;
                val = -f1.getName().compareTo(f2.getName());
                break;
            }
            default: {
                throw new RuntimeException("Unexpected cfField value: " + (Object)((Object)this.cfField));
            }
        }
        return this.ascending ? val : -val;
    }

    public String toString() {
        return (this.ascending ? (char)'+' : '-') + this.cfField.toString();
    }

    public static enum SortBy {
        MODIFIED,
        NAME,
        SIZE;

    }
}

