/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import com.admc.jcreole.CreoleParser;
import com.admc.jcreole.SectionHeading;
import java.util.ArrayList;

public class Sections
extends ArrayList<SectionHeading> {
    public String generateToc(String levelInclusions) {
        if (levelInclusions == null) {
            throw new NullPointerException("levelInclusions may not be null");
        }
        if (levelInclusions.length() != 6) {
            throw new IllegalArgumentException("levelInclusions has length " + levelInclusions.length() + " instead of 6:  " + levelInclusions);
        }
        ArrayList<String> unravelStack = new ArrayList<String>();
        int[] menuLevels = new int[6];
        int nextLevel = 0;
        for (int i = 0; i < levelInclusions.length(); ++i) {
            menuLevels[i] = levelInclusions.charAt(i) == 'x' ? -1 : nextLevel++;
        }
        int menuLevel = -1;
        StringBuilder sb = new StringBuilder();
        for (SectionHeading sh : this) {
            int i;
            int newMenuLevel = menuLevels[sh.getLevel() - 1];
            if (newMenuLevel < 0) continue;
            if (newMenuLevel == menuLevel) {
                sb.append("</li>\n");
            } else if (newMenuLevel > menuLevel) {
                for (i = menuLevel + 1; i <= newMenuLevel; ++i) {
                    sb.append(i == 0 ? "<ul class=\"jcx_toc\">\n" : (i == menuLevel + 1 ? "" : CreoleParser.indent(i)) + "<ul>\n");
                    String ulCloser = "\n" + CreoleParser.indent(i) + "</ul>";
                    unravelStack.add(0, i == newMenuLevel ? "</li>" + ulCloser : ulCloser);
                }
            } else if (newMenuLevel < menuLevel) {
                for (i = menuLevel; i > newMenuLevel; --i) {
                    sb.append((String)unravelStack.remove(0));
                }
                sb.append("</li>\n");
            }
            menuLevel = newMenuLevel;
            sb.append(CreoleParser.indent(menuLevel + 1)).append("<li><a href=\"#").append(sh.getXmlId()).append("\" target=\"_self\">");
            String seqLabel = sh.getSequenceLabel();
            if (seqLabel != null) {
                sb.append("<span class=\"jcx_enum\">").append(seqLabel).append("</span> ");
            }
            sb.append(sh.getText()).append("</a>");
        }
        while (unravelStack.size() > 0) {
            sb.append((String)unravelStack.remove(0));
        }
        return sb.toString();
    }
}

