/*
 * Decompiled with CFR 0.152.
 */
package com.admc.jcreole;

import com.admc.util.FileComparator;
import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class Indexer {
    private Pattern namePattern;
    private String nameFormatString;
    private FileFilter filter;
    private static SimpleDateFormat isoDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static Pattern tailStripperPattern = Pattern.compile("[^/]+/?$");

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public void setNameTranslationMatchPat(String namePatternString) {
        this.namePattern = Pattern.compile(namePatternString);
    }

    public void setNameTranslationFormat(String nameFormatString) {
        this.nameFormatString = nameFormatString;
    }

    public StringBuilder generateTable(File directory, String displayName, boolean listUp, FileComparator.SortBy sortBy, boolean ascendSort) {
        Matcher matcher = null;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory:  " + directory.getAbsolutePath());
        }
        if (this.namePattern == null && this.nameFormatString != null || this.namePattern != null && this.nameFormatString == null) {
            throw new IllegalStateException("'namePattern' and 'nameFormatString' must either both be set or both be null");
        }
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        String name = displayName;
        sb.append("<table class=\"jcreole_dirindex\" width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">\r\n");
        sb.append("<tr>\r\n");
        sb.append("<td align=\"left\"><font size=\"+1\"><strong>");
        sb.append("<a href=\"?sort=");
        try {
            sb.append(URLEncoder.encode(sortBy == FileComparator.SortBy.NAME && ascendSort ? "-" : "+", "UTF-8"));
            sb.append("NAME\">Nodename</a>");
            if (sortBy == FileComparator.SortBy.NAME) {
                sb.append("<sup>").append(ascendSort ? (char)'+' : '-').append("</sup>");
            }
            sb.append("</strong></font></td>\r\n");
            sb.append("<td align=\"center\"><font size=\"+1\"><strong>");
            sb.append("<a href=\"?sort=");
            sb.append(URLEncoder.encode(sortBy == FileComparator.SortBy.SIZE && ascendSort ? "-" : "+", "UTF-8"));
            sb.append("SIZE\">Size</a>");
            if (sortBy == FileComparator.SortBy.SIZE) {
                sb.append("<sup>").append(ascendSort ? (char)'+' : '-').append("</sup>");
            }
            sb.append("</strong></font></td>\r\n");
            sb.append("<td align=\"right\"><font size=\"+1\"><strong>");
            sb.append("<a href=\"?sort=");
            sb.append(URLEncoder.encode(sortBy == FileComparator.SortBy.MODIFIED && ascendSort ? "-" : "+", "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unable to encode to UTF-8");
        }
        sb.append("MODIFIED\">Last Modified</a>");
        if (sortBy == FileComparator.SortBy.MODIFIED) {
            sb.append("<sup>").append(ascendSort ? (char)'+' : '-').append("</sup>");
        }
        sb.append("</strong></font></td>\r\n");
        sb.append("</tr>");
        boolean shade = true;
        if (listUp) {
            sb.append("<tr");
            sb.append(" bgcolor=\"#eeeeee\"");
            sb.append(">\r\n");
            sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
            sb.append("<a href=\"../\"><tt><strong>..</strong>&nbsp;&nbsp;(");
            sb.append(StringEscapeUtils.escapeHtml((String)tailStripperPattern.matcher(displayName).replaceFirst("")));
            sb.append(")</tt></a></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append("&nbsp;");
            sb.append("</tt></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append(StringEscapeUtils.escapeHtml((String)isoDateTimeFormatter.format(directory.getParentFile().lastModified())));
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        List<File> fileList = Arrays.asList(directory.listFiles(this.filter));
        Collections.sort(fileList, new FileComparator(sortBy, ascendSort));
        for (File file : fileList) {
            String nodeName = file.getName();
            if (this.namePattern != null) {
                if (file.isFile()) {
                    matcher = this.namePattern.matcher(nodeName);
                    if (!matcher.matches()) {
                        continue;
                    }
                } else {
                    matcher = null;
                }
            }
            shade = !shade;
            sb.append("<tr");
            if (shade) {
                sb.append(" bgcolor=\"#eeeeee\"");
            }
            sb.append(">\r\n");
            sb.append("<td align=\"left\">&nbsp;&nbsp;\r\n");
            sb.append("<a href=\"");
            if (matcher == null) {
                sb.append(nodeName);
            } else {
                switch (matcher.groupCount()) {
                    case 1: {
                        formatter.format(this.nameFormatString, matcher.group(1));
                        break;
                    }
                    case 2: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2));
                        break;
                    }
                    case 3: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3));
                        break;
                    }
                    case 4: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4));
                        break;
                    }
                    case 5: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5));
                        break;
                    }
                    case 6: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6));
                        break;
                    }
                    case 7: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7));
                        break;
                    }
                    case 8: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8));
                        break;
                    }
                    case 9: {
                        formatter.format(this.nameFormatString, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), matcher.group(5), matcher.group(6), matcher.group(7), matcher.group(8), matcher.group(9));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Pattern captured too many (" + matcher.groupCount() + ") groups: " + this.namePattern);
                    }
                }
            }
            if (file.isDirectory()) {
                sb.append('/');
            }
            sb.append("\"><tt>");
            sb.append(StringEscapeUtils.escapeHtml((String)nodeName));
            if (file.isDirectory()) {
                sb.append('/');
            }
            sb.append("</tt></a></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            if (file.isDirectory()) {
                sb.append("&nbsp;");
            } else if (file.isFile()) {
                sb.append(file.length());
            }
            sb.append("</tt></td>\r\n");
            sb.append("<td align=\"right\"><tt>");
            sb.append(StringEscapeUtils.escapeHtml((String)isoDateTimeFormatter.format(file.lastModified())));
            sb.append("</tt></td>\r\n");
            sb.append("</tr>\r\n");
        }
        sb.append("</table>\r\n");
        return sb;
    }
}

